const { server, user, pass } = JSON.parse(localStorage.getItem('xtream_data'));
async function fetchData() {
  const live = await fetch(`${server}/player_api.php?username=${user}&password=${pass}&action=get_live_streams`).then(r => r.json());
  const movies = await fetch(`${server}/player_api.php?username=${user}&password=${pass}&action=get_vod_streams`).then(r => r.json());
  const series = await fetch(`${server}/player_api.php?username=${user}&password=${pass}&action=get_series`).then(r => r.json());

  const tvList = document.getElementById("tv-list");
  live.slice(0, 12).forEach(c => {
    const item = document.createElement("div");
    const img = c.stream_icon || "https://via.placeholder.com/200x120?text=TV";
    item.className = "card";
    item.innerHTML = `
      <a href="player.html?url=${server}/live/${user}/${pass}/${c.stream_id}.m3u8">
        <img src="${img}" alt="${c.name}">
        <p>${c.name}</p>
      </a>`;
    tvList.appendChild(item);
  });

  const movieList = document.getElementById("movies-list");
  movies.slice(0, 12).forEach(c => {
    const item = document.createElement("div");
    const img = c.stream_icon || c.movie_image || "https://via.placeholder.com/200x120?text=Movie";
    item.className = "card";
    item.innerHTML = `
      <a href="player.html?url=${server}/movie/${user}/${pass}/${c.stream_id}.${c.container_extension}">
        <img src="${img}" alt="${c.name}">
        <p>${c.name}</p>
      </a>`;
    movieList.appendChild(item);
  });

  const seriesList = document.getElementById("series-list");
  series.slice(0, 12).forEach(c => {
    const item = document.createElement("div");
    const img = c.cover || "https://via.placeholder.com/200x120?text=Serie";
    item.className = "card";
    item.innerHTML = `
      <div class="card">
        <img src="${img}" alt="${c.name}">
        <p>${c.name}</p>
      </div>`;
    seriesList.appendChild(item);
  });
}
fetchData();
